local gamename = Var "GameName"
local curGame = GAMESTATE:GetCurrentGame():GetName()

local danceItem = Def.ActorFrame{
	LoadActor(THEME:GetPathG("_style","icons/_base panel single"));
	LoadActor(THEME:GetPathG("_style","icons/dance-4p"));
};
local pumpItem = Def.ActorFrame{
	LoadActor(THEME:GetPathG("_style","icons/_base pump single"));
	LoadActor(THEME:GetPathG("_style","icons/pump-5p"));
};
local kb7Item = Def.ActorFrame{
	LoadActor(THEME:GetPathG("_style","icons/_base kb7"));
	LoadActor(THEME:GetPathG("_style","icons/kb7"));
};
local paraItem = Def.ActorFrame{
	LoadActor(THEME:GetPathG("_style","icons/_base para"));
	LoadActor(THEME:GetPathG("_style","icons/para-5r"));
};
local beatItem = Def.ActorFrame{
	LoadActor(THEME:GetPathG("_style","icons/_base beat single"));
	LoadActor(THEME:GetPathG("_style","icons/beat5"));
};
local popnItem = Def.ActorFrame{
	LoadActor(THEME:GetPathG("_style","icons/_base popn"));
	LoadActor(THEME:GetPathG("_style","icons/popn-9l"));
};
local technoItem = Def.ActorFrame{
	LoadActor(THEME:GetPathG("_style","icons/_base panel single"));
	LoadActor(THEME:GetPathG("_style","icons/techno-8p"));
};
local maniaxItem = Def.ActorFrame{
	LoadActor(THEME:GetPathG("_style","icons/_base maniax single"));
	LoadActor(THEME:GetPathG("_style","icons/maniax-4l"));
};

local gameToItem = {
	dance	= danceItem,
	pump	= pumpItem,
	kb7		= kb7Item,
	para	= paraItem,
	beat	= beatItem,
	popn	= popnItem,
	techno	= technoItem,
	maniax	= maniaxItem
}

local currentGameColorActive = color("1,0.8,0,1")
local currentGameColorInactive = Brightness(color("1,0.8,0,1"),0.75)
local itemColorActive = color("1,1,1,1")

local item = Def.ActorFrame{
	LoadFont("_francophilsans Bold 24px")..{
		Name="GameName";
		Text=ScreenString(gamename);
		InitCommand=cmd(x,-48;y,-8;halign,0;shadowlength,1;zoom,18/24;playcommand,"RealLoseFocus";);
		GainFocusCommand=cmd(diffuse,color("1,0,0,1"));
		LoseFocusCommand=cmd(playcommand,"RealLoseFocus");
		RealLoseFocusCommand=function(self)
			if gamename == curGame then self:diffuse(currentGameColorActive)
			else self:diffuse(itemColorActive)
			end
		end;
	};
	-- available styles
	LoadFont("_francophilsans Bold 24px")..{
		Name="GameStyles";
		Text=ScreenString(gamename.."Styles");
		InitCommand=cmd(x,-48;y,10;halign,0;zoom,12/24;shadowlength,1;);
	};
};

if gameToItem[gamename] then
	local gameItem = gameToItem[gamename]..{
		InitCommand=cmd(x,-96;zoom,0.4;playcommand,"RealLoseFocus");
		RealGainFocusCommand=function(self)
			if gamename == curGame then self:diffuse(currentGameColorActive)
			else self:diffuse(itemColorActive)
			end
		end;
		RealLoseFocusCommand=function(self)
			if gamename == curGame then self:diffuse(currentGameColorInactive)
			else self:diffuse(color("0.8,0.8,0.8,1"))
			end
		end;
		GainFocusCommand=cmd(zoom,0.5;queuecommand,"RealGainFocus");
		LoseFocusCommand=cmd(zoom,0.4;queuecommand,"RealLoseFocus");
	}
	table.insert(item,gameItem)
end

return item